/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.forge;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.SpelunkeryClient;
import com.ordana.spelunkery.forge.ClientEventsForge;
import java.io.IOException;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;

@Mod(value="spelunkery")
public class SpelunkeryForge {
    public static final String MOD_ID = "spelunkery";

    public SpelunkeryForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        Spelunkery.commonInit();
        if (PlatformHelper.getEnv().isClient()) {
            ClientEventsForge.init();
            SpelunkeryClient.init();
        }
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            SpelunkeryForge.registerBuiltinResourcePack(event, Component.m_237113_((String)"Better Vanilla Gems"), "better_vanilla_gems");
            SpelunkeryForge.registerBuiltinResourcePack(event, Component.m_237113_((String)"Unlit Redstone Ores"), "unlit_redstone_ores");
            SpelunkeryForge.registerBuiltinResourcePack(event, Component.m_237113_((String)"Emissive Ores"), "emissive_ores");
            SpelunkeryForge.registerBuiltinResourcePack(event, Component.m_237113_((String)"Emissive Better Vanilla Ores"), "emissive_better_vanilla_ores");
        }
    }

    private static void registerBuiltinResourcePack(AddPackFindersEvent event, MutableComponent name, String folder) {
        event.addRepositorySource((consumer, constructor) -> {
            block7: {
                String path = Spelunkery.res(folder).toString();
                IModFile file = ModList.get().getModFileById(MOD_ID).getFile();
                try (PathPackResources pack = new PathPackResources(path, file.findResource(new String[]{"resourcepacks/" + folder}));){
                    consumer.accept(constructor.create(Spelunkery.res(folder).toString(), (Component)name, false, () -> pack, (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_), Pack.Position.TOP, PackSource.f_10528_, false));
                }
                catch (IOException e) {
                    if (DatagenModLoader.isRunningDataGen()) break block7;
                    e.printStackTrace();
                }
            }
        });
    }
}

